#ifndef __CTempoNoteShiftPanel__
#define __CTempoNoteShiftPanel__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CTempoNoteShiftPanel CTempoNoteShiftPanel.hpp
		 * @brief Compute number of semitones required for a tempo shift
		 *
		 * @date 18/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 * 
		 * $Id: CTempoNoteShiftPanel.hpp,v 1.3 2007/02/11 02:20:27 paul Exp $
		 */
		class CTempoNoteShiftPanel : public CControlPanel, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param root The root control that this control is being added to
			 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
			 * @param area The area of this control relative to the root controls top left
			 */
			CTempoNoteShiftPanel(IControlRoot *root, const long uniqueId, const CRect &area);

			/**
			 * Destruction
			 */
			virtual ~CTempoNoteShiftPanel();

//	===========================================================================

			/**
			 * Handle the action event
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * @enum EControlIds
			 * @brief Enumeration of control identifiers
			 */
			enum EControlIds
			{
				e_tempoNoteShiftBpm1EditBox = 0,				/**< Edit box for bpm closest freq */
				e_tempoNoteShiftBpm2EditBox,					/**< Edit box for freq closest freq */
			};

//	===========================================================================

			/**
			 * Compute note frequnency
			 */
			void computeTempoNoteShift();

//	===========================================================================

			CTextEdit *m_tempoNoteShiftBpm1EditBox;				/**< Edit box for entering the bpm */
			CTextEdit *m_tempoNoteShiftBpm2EditBox;				/**< Edit box for closest frequency */
			CTextLabel *m_tempoNoteShiftOutputValueLabel;		/**< Label for closest division output */
		};
	}
}
#endif	// End of CTempoNoteShiftPanel.hpp